<?php
// --- (Optional) Increase time limit for large imports ---
add_filter( 'ocdi/time_limit', function () { return 600; } );

// ---- Import files (per demo) ----
function theme_import_files() {
    $dir = trailingslashit( get_template_directory() );
    $uri = trailingslashit( get_template_directory_uri() );

    return array(
        array(
            'import_file_name'              => 'Default',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-default/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-default/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-default/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-default/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/01_Thumbnail_01.png',
            'preview_url'                   => 'https://demos.codexcoder.com/topnews/',
            'import_notice'                 => esc_html__( 'After you import the demo, set widgets from Appearance → Widgets. Set front page from Settings → Reading. If needed, import theme options JSON from Theme Options → Backup Importer.', 'top-news' ),

            // ---- Custom per-demo values (you control these) ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-default/options.txt',
            'front_page'                    => 'Home',
            'blog_page'                     => 'Blog',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Fashion',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-fashion/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-fashion/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-fashion/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-fashion/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/02_Thumbnail_02.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/fashion/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-fashion/options.txt',
            'front_page'                    => 'Home',
            'blog_page'                     => 'Blog',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Sports',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-sports/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-sports/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-sports/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-sports/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/03_Thumbnail_03.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/sports/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-sports/options.txt',
            'front_page'                    => 'Home',
            'blog_page'                     => 'Blog',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Viral Buzz',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-viral-buzz/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-viral-buzz/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-viral-buzz/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-viral-buzz/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/04_Thumbnail_Viral.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/viral-buzz/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-viral-buzz/options.txt',
            'front_page'                    => '',
            'blog_page'                     => '',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Health',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-health/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-health/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-health/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-health/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/05_Thumbnail_Health.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/health/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-health/options.txt',
            'front_page'                    => 'Home',
            'blog_page'                     => 'Blog',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Video',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-video/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-video/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-video/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-video/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/06_Thumbnail_Video.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/video/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-video/options.txt',
            'front_page'                    => 'Home',
            'blog_page'                     => 'Blog',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Technology',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-tech/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-tech/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-tech/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-tech/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/07_Thumbnail_Tech.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/tech/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-tech/options.txt',
            'front_page'                    => 'Home',
            'blog_page'                     => 'Blog',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Animals',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-animal/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-animal/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-animal/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-animal/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/08_Thumbnail_Animals.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/animal/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-animal/options.txt',
            'front_page'                    => 'Home',
            'blog_page'                     => 'Blog',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Classic Blog',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-blog/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-blog/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-blog/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-blog/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/09_Thumbnail_Classic-Blog.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/classic-blog/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-blog/options.txt',
            'front_page'                    => '',
            'blog_page'                     => '',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Foods',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-food/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-food/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-food/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-food/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/10_Thumbnail_Food.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/food/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-food/options.txt',
            'front_page'                    => 'Home',
            'blog_page'                     => 'Blog',
            'primary_menu'                  => 'Primary Menu',
        ),

        array(
            'import_file_name'              => 'Travel',
            // Local files
            'local_import_file'             => $dir . 'demo/demo-data/top-news-travel/content.xml',
            'local_import_widget_file'      => $dir . 'demo/demo-data/top-news-travel/widgets.wie',
            'local_import_customizer_file'  => $dir . 'demo/demo-data/top-news-travel/customizer.dat',
            // (Optional) URL fallbacks
            'import_file_url'               => $uri . 'demo/demo-data/top-news-travel/content.xml',
            // Preview/meta
            'import_preview_image_url'      => 'https://demos.codexcoder.com/topnews-demos/assets/images/Thumbnail/11_Thumbnail_Travel.png',
            'preview_url'                   => 'https://demos.codexcoder.com/top-news/travel/',
            'import_notice'                 => esc_html__( 'Same steps as above.', 'top-news' ),

            // ---- Custom per-demo values ----
            'cs_options_file'               => $dir . 'demo/demo-data/top-news-travel/options.txt',
            'front_page'                    => 'Home',
            'blog_page'                     => '',
            'primary_menu'                  => 'Primary Menu',
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'theme_import_files' );

// ---- Intro text (optional) ----
function ocdi_plugin_intro_text( $default_text ) {
    $default_text .= '<div class="ocdi__intro-text" style="max-width:700px"><p>Please click on the <strong>Import Demo Data</strong> button and wait. It may take a few minutes.</p></div>';
    return $default_text;
}
add_filter( 'pt-ocdi/plugin_intro_text', 'ocdi_plugin_intro_text' );

// ---- Wipe previous demo data before each import ----
add_action( 'pt-ocdi/before_content_import', 'topnews_ocdi_wipe_site_before_import' );
function topnews_ocdi_wipe_site_before_import( $selected_import ) {
    if ( ! current_user_can( 'import' ) ) {
        return;
    }

    @set_time_limit( 0 );

    // 1) Reset front/blog page
    update_option( 'show_on_front', 'posts' );
    delete_option( 'page_on_front' );
    delete_option( 'page_for_posts' );

    // 2) Delete posts/pages/media/custom posts
    $exclude_pts = array( 'revision', 'customize_changeset', 'nav_menu', 'oembed_cache', 'user_request', 'wp_template', 'wp_template_part' );
    $post_types  = get_post_types( array(), 'names' );
    foreach ( $post_types as $pt ) {
        if ( in_array( $pt, $exclude_pts, true ) ) {
            continue;
        }
        $ids = get_posts( array(
            'post_type'      => $pt,
            'post_status'    => 'any',
            'numberposts'    => -1,
            'fields'         => 'ids',
            'suppress_filters' => true,
        ) );
        if ( $ids ) {
            foreach ( $ids as $id ) {
                if ( 'attachment' === get_post_type( $id ) ) {
                    wp_delete_attachment( $id, true );
                } else {
                    wp_delete_post( $id, true );
                }
            }
        }
    }

    // 3) Delete menus
    $menus = wp_get_nav_menus();
    if ( ! empty( $menus ) ) {
        foreach ( $menus as $menu ) {
            wp_delete_nav_menu( $menu->term_id );
        }
    }
    set_theme_mod( 'nav_menu_locations', array() );

    // 4) Delete terms except Uncategorized
    $taxonomies = get_taxonomies( array(), 'names' );
    foreach ( $taxonomies as $tax ) {
        if ( 'nav_menu' === $tax ) {
            continue;
        }
        $terms = get_terms( array(
            'taxonomy'   => $tax,
            'hide_empty' => false,
        ) );
        if ( is_wp_error( $terms ) || empty( $terms ) ) {
            continue;
        }
        foreach ( $terms as $term ) {
            if ( 'category' === $tax && (int) $term->term_id === (int) get_option( 'default_category', 1 ) ) {
                continue;
            }
            wp_delete_term( $term->term_id, $tax );
        }
    }

    // 5) Reset widgets
    update_option( 'sidebars_widgets', array( 'wp_inactive_widgets' => array() ) );

    // 6) Reset customizer
    remove_theme_mods();

    // 7) Reset Codestar options
    delete_option( '_cs_options' );

    // 8) Flush
    delete_transient( 'ocdi_importer_data' );
    flush_rewrite_rules();
}

// ---- After import: assign menus/pages/options ----
function topnews_ocdi_after_import_setup( $selected_import ) {
    // Menus
    $menu_name   = isset( $selected_import['primary_menu'] ) ? $selected_import['primary_menu'] : 'Primary Menu';
    $primary_nav = get_term_by( 'name', $menu_name, 'nav_menu' );
    if ( $primary_nav && ! is_wp_error( $primary_nav ) ) {
        $locations            = (array) get_theme_mod( 'nav_menu_locations', array() );
        $locations['primary'] = (int) $primary_nav->term_id;
        set_theme_mod( 'nav_menu_locations', $locations );
    }

    // Pages
    $front_title = isset( $selected_import['front_page'] ) ? $selected_import['front_page'] : 'Home Page';
    $blog_title  = isset( $selected_import['blog_page'] )  ? $selected_import['blog_page']  : 'Blog';

    $front_page  = get_page_by_title( $front_title );
    if ( ! $front_page ) { $front_page = get_page_by_title( 'Home' ); }
    $blog_page   = get_page_by_title( $blog_title );

    if ( $front_page ) {
        update_option( 'show_on_front', 'page' );
        update_option( 'page_on_front', $front_page->ID );
    }
    if ( $blog_page ) {
        update_option( 'page_for_posts', $blog_page->ID );
    }

    // Codestar options
    if ( function_exists( 'cs_decode_string' ) ) {
        $file = isset( $selected_import['cs_options_file'] ) ? $selected_import['cs_options_file'] : '';
        if ( $file && file_exists( $file ) ) {
            $data    = file_get_contents( $file );
            $decoded = cs_decode_string( $data );
            if ( $decoded ) {
                update_option( '_cs_options', $decoded );
            }
        }
    }
}
add_action( 'pt-ocdi/after_import', 'topnews_ocdi_after_import_setup' );
